/*! ProjectName 27-03-2016 | Project base: Jekins.ru */
/* header ***********************/
var Header = (function () {
    return {
        init: function () {
            $('.header__scene').parallax();
        }
    };
})();
/* nav-list ***********************/
var Navlist = (function() {
  var
    item = '.nav-list li',
    dropdown = '.nav-list__dropdown',
    speed = 200;

  return {
    init: function() {
      if ($(window).width() > 767) {
        this.hoverInit();
      }
    },
    hoverInit: function() {
      $(item).hover(function() {
        if ($(this).children(dropdown).length > 0) {
          $(this).children(dropdown).stop().fadeIn(speed);
        }
      }, function() {
        $(this).children(dropdown).stop().fadeOut(speed);
      });
    }
  };
})();
/* main-menu ***********************/
var MainMenu = (function() {
  var
    item = '.main-nav li',
    dropdown = '.main-nav__dropdown',
    speed = 200;

  return {
    init: function() {
      if ($(window).width() > 767) {
        this.hoverInit();
      }
    },
    hoverInit: function() {
      $(item).hover(function() {
        if ($(this).children(dropdown).length > 0) {
          $(this).children(dropdown).stop().fadeIn(speed);
        }
      }, function() {
        $(this).children(dropdown).stop().fadeOut(speed);
      });
    }
  };
})();
/* sidebar ***********************/
var Sidebar = (function() {
  var
    barLink = '[data-element="sidebar__btn"]',
    panel = '[data-element="sidebar__panel"]',
    active = 'active';

  return {
    init: function() {
      this.sidebarInit();
      this.openCloseInit();
    },
    sidebarInit: function() {
      if ($(window).width() < 767) {
        $(panel).appendTo($('body'));
      }
    },
    openCloseInit: function() {
      var
        sidebar = $(panel).children('ul'),
        keys = {
          37: 1,
          38: 1,
          39: 1,
          40: 1
        };

      function preventDefault(e) {
        e = e || window.event;
        if (e.preventDefault)
          e.preventDefault();
        e.returnValue = false;
      }

      function preventDefaultForScrollKeys(e) {
        if (keys[e.keyCode]) {
          preventDefault(e);
          return false;
        }
      }

      function disableScroll() {
        if (window.addEventListener) // older FF
          window.addEventListener('DOMMouseScroll', preventDefault, false);
        window.onwheel = preventDefault; // modern standard
        window.onmousewheel = document.onmousewheel = preventDefault; // older browsers, IE
        window.ontouchmove = preventDefault; // mobile
        document.onkeydown = preventDefaultForScrollKeys;
      }

      function enableScroll() {
        if (window.removeEventListener)
          window.removeEventListener('DOMMouseScroll', preventDefault, false);
        window.onmousewheel = document.onmousewheel = null;
        window.onwheel = null;
        window.ontouchmove = null;
        document.onkeydown = null;
      }

      function closePanel() {
        $(panel).removeClass(active);
        enableScroll();
      }

      function openPanel() {
        $(panel).addClass(active);
        disableScroll();
      }

      $(panel).on('click', function(e) {
        var
          $this = $(this),
          target = $(e.target);

        if ($this.hasClass(active)) {
          if (target.is(sidebar)) {
            return;
          } else {
            closePanel();
          }
        }
      });

      $('body').on('click', barLink, function() {
        if ($(panel).hasClass(active)) {
          closePanel();
        } else {
          openPanel();
        }

        return false;
      });
    }
  };
})();
/* common ***********************/
//TestModule
var TestModule = (function () {
    var
        testText = 'Design from jekins.ru!';

    return {
        init: function () {
            this.consoleTest();
        },
        consoleTest: function () {
            console.log(testText);
        }
    };
})();
//ArticleEmpty
var ArticleEmpty = (function () {

    return {
        init: function () {
function isEmpty( el ){
      return !$.trim(el.html())
  }
$('div.article-block .article-block__content').each(function(){

$(this).find('p').each(function(){

  if (isEmpty($(this))) {
      $(this).remove();
  }
});

});
           
        }
    };
})();


//Init plugins
var Plugins = (function () {
    return {
        init: function () {
            //plugins
            TestModule.init();
        }
    };
})();

//Init blocks
var Blocks = (function () {
    return {
        init: function () {
            //blocksInitPlace - do not delete this comment!
Sidebar.init();
Navlist.init();
Header.init();
MainMenu.init();
ArticleEmpty.init();
        }
    };
})();


$(function () {
    Plugins.init();
    Blocks.init();
});


 /*(function($) {
$(function() {
 if (!$.cookie('was')) {
 window.open('http://topkino.tv', '_blank');
 }
 $.cookie('was', true, {
 expires: 365,
 path: '/'
 });
})
})(jQuery)*/